local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// create label
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// create button
	self.Button = CtlButton_class:create( self );
	self.Button:SetSize( 24, 24 );
	self.Button:AddEvent( "OnClick", "OnClick", self );
	
end

//
function PANEL:OnClick( )
	// call
	if( self.LinkedClass ) then
		self.LinkedClass:CallEvent( "OnClick" );

	end
	
end

// set text
function PANEL:SetText( label, button )
	self.Label:SetText( label );
	self.Button:SetText( button );
	
end

// scheme
function PANEL:ApplySchemeSettings( )
	// set fonts and colors
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end

// perform layout
function PANEL:PerformLayout( )
	// width/height
	local width, height = self:GetSize();
	
	// size text
	self.Label:SizeToContents();
	self.Label:SetPos(
		8, ( height * 0.5 ) - ( self.Label:GetTall() * 0.5 )
	);

	// size button.
	self.Button:SizeToText();
	
	// position
	local _, button_width = self.Button:GetSize();
	self.Button:SetPos( ( width - button_width ) - 20, ( height * 0.5 ) - 12 );
	
end


// draw
function PANEL:Paint( )
	// fetch olors.
	local color = AppFramework:Theme().colors['window_face'];
	local bgcolor = AppFramework:Theme().colors['border_dark'];
	
	// width height
	local width, height = self:GetSize();
	
	// square border.
	surface.SetDrawColor(
		bgcolor.r,
		bgcolor.g,
		bgcolor.b,
		bgcolor.a
	);
	surface.DrawRect(
		0, 0,
		width, height
	);
	
	
	// square border.
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawRect(
		1, 1,
		width - 2, height - 2
	);
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_contextbutton", PANEL, "Panel" );




// create app framework control.
CtlContextButton_class 	= Control_class:create( nil, false, "ctl_contextbutton" );

// set smoothbar
function CtlContextButton_class:SetText( v, v2 )
	self:GetHandle():SetText( v, v2 );
	
end
